/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ServerDispatch {
    private Map<Integer, NetworkServer> servers = new HashMap<Integer, NetworkServer>();

    protected ServerDispatch() {
    }

    protected void addServer(int n, NetworkServer networkServer) {
        this.servers.put(n, networkServer);
    }

    protected int install_ServerDispatch(Properties properties, String string, int n, int n2, int n3, NetworkListener networkListener) {
        boolean[] blArray = new boolean[n3];
        Arrays.fill(blArray, false);
        blArray[n] = true;
        string = string + "server";
        int n4 = string.length();
        for (String string2 : properties.stringPropertyNames()) {
            Object object;
            int n5;
            if (!string2.startsWith(string)) continue;
            try {
                n5 = Integer.valueOf(string2.substring(n4), 16);
            }
            catch (Exception exception) {
                System.err.format("Invalid Server property: skipping %s\n", string2);
                continue;
            }
            if (n5 < 0 || n5 >= n3) {
                System.err.format("Invalid Server ID %02x: skipping %s\n", n5, string2);
                continue;
            }
            if (blArray[n5]) {
                System.err.format("Duplicate Server ID %02x: skipping %s\n", n5, string2);
                continue;
            }
            blArray[n5] = true;
            String string3 = properties.getProperty(string2);
            Vector<String> vector = new Vector<String>(Arrays.asList(string3.split("\\s")));
            if (vector.get(0).equalsIgnoreCase("HostFileBdos")) {
                String string4 = String.format("hostfilebdos%02x", n5);
                CpnetServer cpnetServer = new CpnetServer(properties, string4, 'P', (byte)n5, 1, null);
                object = new HostFileBdos(properties, string4, vector, n, cpnetServer);
            } else if (vector.get(0).equalsIgnoreCase("Socket")) {
                object = new CpnetSocketClient(properties, vector, n5, n, networkListener);
            } else {
                System.err.format("Unrecognized server %02x: \"%s\"\n", n5, string3);
                continue;
            }
            this.addServer(n5, (NetworkServer)object);
            System.err.format("Server %02x: %s\n", n5, string3);
            if (networkListener != null) {
                networkListener.addNode(n5, 112);
            }
            if (n2 != -1) continue;
            n2 = n5;
        }
        return n2;
    }

    public static int getCode(byte[] byArray) {
        return byArray[0] & 0xFF;
    }

    public static int getBC(byte[] byArray) {
        return byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8;
    }

    public static int getDE(byte[] byArray) {
        return byArray[3] & 0xFF | (byArray[4] & 0xFF) << 8;
    }

    public static int getHL(byte[] byArray) {
        return byArray[5] & 0xFF | (byArray[6] & 0xFF) << 8;
    }

    public static void putCode(byte[] byArray, int n) {
        byArray[0] = (byte)n;
    }

    public static void putBC(byte[] byArray, int n) {
        byArray[1] = (byte)n;
        byArray[2] = (byte)(n >> 8);
    }

    public static void putDE(byte[] byArray, int n) {
        byArray[3] = (byte)n;
        byArray[4] = (byte)(n >> 8);
    }

    public static void putHL(byte[] byArray, int n) {
        byArray[5] = (byte)n;
        byArray[6] = (byte)(n >> 8);
    }

    protected void shutdown() {
        for (NetworkServer networkServer : this.servers.values()) {
            networkServer.shutdown();
        }
    }

    protected byte[] checkRecvMsg(byte by) {
        NetworkServer networkServer;
        byte[] byArray = null;
        Iterator<NetworkServer> iterator = this.servers.values().iterator();
        while (iterator.hasNext() && (byArray = (networkServer = iterator.next()).checkRecvMsg(by)) == null) {
        }
        return byArray;
    }

    protected byte[] sendMsg(byte[] byArray, int n) {
        int n2 = byArray[1] & 0xFF;
        NetworkServer networkServer = this.servers.get(n2);
        if (networkServer == null) {
            System.err.format("Attempted send to null server %02x\n", n2);
            byArray[0] = 1;
            byte by = byArray[2];
            byArray[2] = byArray[1];
            byArray[1] = by;
            byArray[4] = 1;
            byArray[5] = -1;
            byArray[6] = 12;
            return byArray;
        }
        byte[] byArray2 = networkServer.sendMsg(byArray, n);
        return byArray2;
    }

    protected byte[] sendMagNETMsg(byte[] byArray, int n) {
        int n2 = ServerDispatch.getCode(byArray);
        ServerDispatch.putCode(byArray, n2 | 0x80);
        int n3 = byArray[4] & 0xFF;
        NetworkServer networkServer = this.servers.get(n3);
        if (networkServer == null) {
            System.err.format("Attempted send to null server %02x\n", n3);
            ServerDispatch.putCode(byArray, 56);
            ServerDispatch.putBC(byArray, 0);
            ServerDispatch.putDE(byArray, 1);
            return byArray;
        }
        byte[] byArray2 = networkServer.sendMsg(byArray, n);
        ServerDispatch.putCode(byArray, n2);
        return byArray2;
    }
}

