/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;

class Printer_Paper {
    float _fa;
    int _off_x;
    int _off_y;
    int _pwx;
    int _phx;
    private Font __font = null;
    private plot[] _plotArray;
    private int _nplots;
    private int _xplots;
    private int _last = -1;

    public void init(Font font, float f) {
        this.__font = font;
        this._fa = f;
    }

    public boolean empty() {
        return this._xplots == 0;
    }

    public void setScale(int n, int n2) {
        this._pwx = n;
        this._phx = n2;
    }

    void clear() {
        this._nplots = 0;
        this._xplots = 0;
        this._plotArray = null;
    }

    public void setPage(int n, int n2, int n3, int n4) {
        if (n == n2) {
            // empty if block
        }
        this._off_x = n3;
        this._off_y = n4;
        this.clear();
    }

    public Font getFont() {
        return this.__font;
    }

    public Printer_Paper() {
        this.clear();
    }

    public void addPlot(String string, float f, float f2) {
        int n = this._xplots;
        if (this._xplots + 1 > this._nplots) {
            int n2 = this._nplots;
            this._nplots += 256;
            plot[] plotArray = new plot[this._nplots];
            if (n2 > 0) {
                System.arraycopy(this._plotArray, 0, plotArray, 0, n2);
            }
            this._plotArray = plotArray;
        }
        this._plotArray[n] = new plot(string, f + (float)this._off_x, f2 + (float)this._off_y);
        ++this._xplots;
        this._last = n;
    }

    public void appendLastPlot(String string, float f, float f2) {
        if (this._last < 0) {
            this.addPlot(string, f, f2);
        } else {
            this._plotArray[this._last].s = this._plotArray[this._last].s + string;
        }
    }

    public void prependLastPlot(String string, float f, float f2) {
        if (this._last < 0) {
            this.addPlot(string, f, f2);
        } else {
            this._plotArray[this._last].s = string + this._plotArray[this._last].s;
            this._plotArray[this._last].x = f + (float)this._off_x;
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n, PaperPaintable paperPaintable) {
        if (n == 0) {
            // empty if block
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (paperPaintable != null) {
            paperPaintable.paint(graphics2D, pageFormat);
        }
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        graphics2D.translate(d, d2);
        graphics2D.setFont(this.__font);
        graphics2D.setColor(Color.black);
        int n2 = 0;
        for (n2 = 0; n2 < this._xplots; ++n2) {
            graphics2D.drawString(this._plotArray[n2].s, this._plotArray[n2].x, this._plotArray[n2].y + this._fa);
        }
        return 0;
    }

    class plot {
        public String s;
        public float x;
        public float y;

        plot(String string, float f, float f2) {
            this.s = string;
            this.x = f;
            this.y = f2;
        }
    }
}

