/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.Map;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

class PrinterConsole {
    private String _descr;
    private JFrame _frame;
    private JMenuBar _mb;
    private JLabel _chg_txt;
    private JLabel _font_txt;
    private JLabel _pitch_txt;
    private JLabel _file_txt;
    private JLabel _paper_txt;
    private JLabel _off_txt;
    private JLabel _pages_txt;
    private JLabel _status_txt;

    public JFrame getFrame() {
        return this._frame;
    }

    public void setChanges(boolean bl) {
        if (bl) {
            this._chg_txt.setText("* Changes pending END OF JOB");
        } else {
            this._chg_txt.setText(" ");
        }
    }

    public void setFont(Font font) {
        Object obj;
        String string = font.getFontName();
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        string = "PrintWheel: " + string + " " + font.getSize();
        Map<TextAttribute, ?> map = font.getAttributes();
        if (map.containsKey(TextAttribute.WEIGHT)) {
            obj = map.get(TextAttribute.WEIGHT);
            if (obj == TextAttribute.WEIGHT_BOLD || obj == TextAttribute.WEIGHT_DEMIBOLD || obj == TextAttribute.WEIGHT_EXTRABOLD || obj == TextAttribute.WEIGHT_HEAVY || obj == TextAttribute.WEIGHT_MEDIUM || obj == TextAttribute.WEIGHT_SEMIBOLD || obj == TextAttribute.WEIGHT_ULTRABOLD) {
                string = string + " BOLD";
            } else if (obj == TextAttribute.WEIGHT_LIGHT || obj == TextAttribute.WEIGHT_DEMILIGHT || obj == TextAttribute.WEIGHT_EXTRA_LIGHT) {
                string = string + " LIGHT";
            }
        }
        if (map.containsKey(TextAttribute.POSTURE) && (obj = map.get(TextAttribute.POSTURE)) == TextAttribute.POSTURE_OBLIQUE) {
            string = string + " ITALIC";
        }
        this._font_txt.setText(string);
    }

    public void setPitch(int n, int n2) {
        this._pitch_txt.setText("CPI: " + n + "    LPI: " + n2);
    }

    public void setPaper(PaperDialog.PaperMediaSize paperMediaSize, OrientationRequested orientationRequested) {
        this._paper_txt.setText("Paper: " + paperMediaSize.toString() + "/" + orientationRequested.toString());
    }

    public void setPosition(float f, float f2) {
        this._off_txt.setText("Offsets: left " + f + ", top " + f2 + " (inches)");
    }

    public void setFileName(File file) {
        if (file != null) {
            this._file_txt.setText("Output File: " + file.getAbsolutePath());
        } else {
            this._file_txt.setText("Output File: none");
        }
    }

    public void setPages(int n, int n2) {
        this._pages_txt.setText("Pages Printed: " + n + "." + n2);
    }

    public void setStatus(String string) {
        this._status_txt.setText("Printer: " + string);
    }

    public PrinterConsole(String string) {
        this._descr = string;
        this._frame = new JFrame(this._descr);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._frame.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.bottom = 2;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        gridBagConstraints.anchor = 17;
        this._chg_txt = new JLabel(" ");
        this._chg_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._chg_txt, gridBagConstraints);
        this._frame.add(this._chg_txt);
        ++gridBagConstraints.gridy;
        this._font_txt = new JLabel("Font:");
        this._font_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._font_txt, gridBagConstraints);
        this._frame.add(this._font_txt);
        ++gridBagConstraints.gridy;
        this._pitch_txt = new JLabel("Pitch:");
        this._pitch_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._pitch_txt, gridBagConstraints);
        this._frame.add(this._pitch_txt);
        ++gridBagConstraints.gridy;
        this._paper_txt = new JLabel("Paper:");
        this._paper_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._paper_txt, gridBagConstraints);
        this._frame.add(this._paper_txt);
        ++gridBagConstraints.gridy;
        this._off_txt = new JLabel("Offsets:");
        this._off_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._off_txt, gridBagConstraints);
        this._frame.add(this._off_txt);
        ++gridBagConstraints.gridy;
        this._file_txt = new JLabel("Output File:");
        this._file_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._file_txt, gridBagConstraints);
        this._frame.add(this._file_txt);
        ++gridBagConstraints.gridy;
        this._pages_txt = new JLabel("Pages Printed:");
        this._pages_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._pages_txt, gridBagConstraints);
        this._frame.add(this._pages_txt);
        ++gridBagConstraints.gridy;
        this._status_txt = new JLabel("Printer:");
        this._status_txt.setPreferredSize(new Dimension(600, 20));
        gridBagLayout.setConstraints(this._status_txt, gridBagConstraints);
        this._frame.add(this._status_txt);
        ++gridBagConstraints.gridy;
        this._mb = new JMenuBar();
        this._frame.setJMenuBar(this._mb);
        this._frame.setDefaultCloseOperation(3);
        this._frame.pack();
        this._frame.setVisible(true);
    }

    public void addMenu(JMenu jMenu) {
        this._mb.add(jMenu);
    }
}

