/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PaperDialog {
    JPanel _dia_pn = new JPanel();
    private JComboBox<PaperMediaSize> _ms_cb;
    private JComboBox<OrientationRequested> _or_cb;
    private JCheckBox _gb_cb;
    private JTextField _lm_txt;
    private JTextField _tm_txt;
    private float _lm;
    private float _tm;
    PaperMediaSize _ms;
    OrientationRequested _or;
    JOptionPane _prefs;
    Object[] _btns;

    public void setMedia(PaperMediaSize paperMediaSize) {
        this._ms = paperMediaSize;
        this._ms_cb.setSelectedItem((Object)paperMediaSize);
    }

    public PaperMediaSize getMedia() {
        return (PaperMediaSize)((Object)this._ms_cb.getSelectedItem());
    }

    public void setOrient(OrientationRequested orientationRequested) {
        this._or = orientationRequested;
        this._or_cb.setSelectedItem(orientationRequested);
    }

    public OrientationRequested getOrient() {
        return (OrientationRequested)this._or_cb.getSelectedItem();
    }

    public PaperPaintable getBkground() {
        if (this._gb_cb.isSelected()) {
            return new GreenbarPaper();
        }
        return null;
    }

    public void setLeft(float f) {
        this._lm = f;
        this._lm_txt.setText(Float.toString(f));
    }

    public float getLeft() {
        float f = -1.0f;
        try {
            f = Float.parseFloat(this._lm_txt.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public void setTop(float f) {
        this._tm = f;
        this._tm_txt.setText(Float.toString(f));
    }

    public float getTop() {
        float f = -1.0f;
        try {
            f = Float.parseFloat(this._tm_txt.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public PaperDim paperSize(PaperMediaSize paperMediaSize) {
        PaperDim paperDim = null;
        if (paperMediaSize == PaperMediaSize.NA_LETTER) {
            paperDim = new PaperDim(8.5f, 11.0f);
        } else if (paperMediaSize == PaperMediaSize.NA_LEGAL) {
            paperDim = new PaperDim(8.5f, 14.0f);
        } else if (paperMediaSize == PaperMediaSize.NA_FORMS) {
            paperDim = new PaperDim(11.0f, 14.0f);
        }
        return paperDim;
    }

    public boolean doDialog(JFrame jFrame) {
        this._gb_cb.setSelected(false);
        boolean bl = false;
        JDialog jDialog = this._prefs.createDialog(jFrame, "Set Paper Options");
        jDialog.setVisible(true);
        Object object = this._prefs.getValue();
        if (this._btns[0].equals(object)) {
            PaperMediaSize paperMediaSize;
            float f = this.getLeft();
            if (f >= 0.0f && f != this._lm) {
                bl = true;
            }
            if ((f = this.getTop()) >= 0.0f && f != this._tm) {
                bl = true;
            }
            if ((paperMediaSize = this.getMedia()) != this._ms) {
                bl = true;
            }
            OrientationRequested orientationRequested = this.getOrient();
            if (this._gb_cb.isSelected()) {
                bl = true;
            }
            if (orientationRequested != this._or) {
                bl = true;
            }
        }
        return bl;
    }

    public PaperDialog() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this._dia_pn.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 17;
        Vector<PaperMediaSize> vector = new Vector<PaperMediaSize>();
        vector.add(PaperMediaSize.NA_LETTER);
        vector.add(PaperMediaSize.NA_LEGAL);
        vector.add(PaperMediaSize.NA_FORMS);
        this._ms_cb = new JComboBox(vector);
        gridBagLayout.setConstraints(this._ms_cb, gridBagConstraints);
        this._dia_pn.add(this._ms_cb);
        ++gridBagConstraints.gridy;
        Vector<OrientationRequested> vector2 = new Vector<OrientationRequested>();
        vector2.add(OrientationRequested.PORTRAIT);
        vector2.add(OrientationRequested.LANDSCAPE);
        this._or_cb = new JComboBox(vector2);
        gridBagLayout.setConstraints(this._or_cb, gridBagConstraints);
        this._dia_pn.add(this._or_cb);
        ++gridBagConstraints.gridy;
        this._gb_cb = new JCheckBox("Greenbar");
        gridBagLayout.setConstraints(this._gb_cb, gridBagConstraints);
        this._dia_pn.add(this._gb_cb);
        ++gridBagConstraints.gridy;
        this._lm_txt = new JTextField();
        this._lm_txt.setPreferredSize(new Dimension(50, 20));
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Left Offset:"));
        jPanel.add(this._lm_txt);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this._dia_pn.add(jPanel);
        ++gridBagConstraints.gridy;
        this._tm_txt = new JTextField();
        this._tm_txt.setPreferredSize(new Dimension(50, 20));
        jPanel = new JPanel();
        jPanel.add(new JLabel("Top Offset:"));
        jPanel.add(this._tm_txt);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this._dia_pn.add(jPanel);
        ++gridBagConstraints.gridy;
        this._btns = new Object[2];
        this._btns[0] = "Apply";
        this._btns[1] = "Cancel";
        this._prefs = new JOptionPane(this._dia_pn, 3, 1, null, this._btns);
    }

    public class PaperDim {
        float _w;
        float _h;

        public PaperDim(float f, float f2) {
            this._w = f;
            this._h = f2;
        }

        public float getWidth() {
            return this._w;
        }

        public float getHeight() {
            return this._h;
        }
    }

    public static enum PaperMediaSize {
        NA_LETTER,
        NA_LEGAL,
        NA_FORMS;

    }
}

