/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class NetBootSys
implements NetBoot {
    static final int MEMTOP = 0;
    static final int COMLEN = 1;
    static final int BNKTOP = 2;
    static final int BNKLEN = 3;
    static final int ENTRY = 4;
    static final int CNFTBL = 6;
    static final int COPY = 16;
    static final int SIGNON = 128;
    static final int IMAGE = 256;
    static final int RECLEN = 128;
    private int sid;
    private int nid;
    private int memtop;
    private int comlen;
    private int bnktop;
    private int bnklen;
    private int entry;
    private int cfgtbl;
    private int curdma;
    private int reccnt;
    private boolean org0;
    private byte[] image;

    public NetBootSys(String string, String string2, byte[] byArray) throws Exception {
        this.nid = byArray[2] & 0xFF;
        this.sid = byArray[1] & 0xFF;
        int n = (byArray[4] & 0xFF) + 1;
        String string3 = "";
        if (n > 2) {
            string3 = new String(byArray, 6, n - 2).toLowerCase();
        }
        File file = null;
        if (string3.length() > 0) {
            file = new File(String.format("%s/cid%02X%s", string, this.nid, string3));
            if (!file.exists()) {
                file = new File(String.format("%s/cid%02X%s.sys", string, this.nid, string3));
            }
            if (!file.exists()) {
                file = new File(String.format("%s/%s", string, string3));
            }
            if (!file.exists()) {
                file = new File(String.format("%s/%s.sys", string, string3));
            }
        } else {
            file = new File(String.format("%s/cid%02X.sys", string, this.nid));
            if (!file.exists()) {
                file = new File(String.format("%s/%s", string, string2));
            }
        }
        if (!file.exists()) {
            System.err.format("No boot file \"%s\"\n", file.getAbsolutePath());
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.image = new byte[fileInputStream.available()];
            fileInputStream.read(this.image);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        if (this.image[1] == 0 && this.image[3] == 0) {
            System.err.format("No segments to load \"%s\"\n", file.getAbsolutePath());
            throw new RuntimeException("No segments to load");
        }
        this.memtop = (this.image[0] & 0xFF) << 8;
        this.comlen = (this.image[1] & 0xFF) << 8;
        this.bnktop = (this.image[2] & 0xFF) << 8;
        this.bnklen = (this.image[3] & 0xFF) << 8;
        this.entry = this.image[4] & 0xFF | (this.image[5] & 0xFF) << 8;
        this.cfgtbl = this.image[6] & 0xFF | (this.image[7] & 0xFF) << 8;
        if (this.cfgtbl != 0) {
            this.fixCfgTbl();
        }
        this.org0 = this.image[16] == 67;
        System.err.format("Client %02x booting file \"%s\" (ORG0 %s)\n", this.nid, file.getAbsolutePath(), this.org0);
    }

    private void fixCfgTbl() {
        int n = this.memtop - (this.cfgtbl & 0xFF80) - 128 & 0xFFFF;
        n |= this.cfgtbl & 0x7F;
        n += 258;
        for (int i = 0; i < 18; ++i) {
            int n2 = i * 2;
            if ((this.image[n + n2] & 0x80) == 0 || (this.image[n + n2 + 1] & 0xFF) != 255) continue;
            this.image[n + n2 + 1] = (byte)this.sid;
        }
    }

    @Override
    public boolean hasRes() {
        return this.comlen > 0;
    }

    @Override
    public boolean hasBnk() {
        return this.bnklen > 0;
    }

    @Override
    public void setLoadMsg(byte[] byArray, int n, int n2) {
        System.arraycopy(this.image, 128, byArray, n, 128);
    }

    @Override
    public int startResAddr() {
        this.curdma = this.comlen + 256 - 128;
        this.reccnt = this.comlen / 128;
        return this.memtop - this.comlen & 0xFFFF;
    }

    @Override
    public int nextResRec(byte[] byArray, int n, int n2) {
        System.arraycopy(this.image, this.curdma, byArray, 5, 128);
        this.curdma -= 128;
        --this.reccnt;
        return this.reccnt;
    }

    @Override
    public int startBnkAddr() {
        this.curdma = this.comlen + this.bnklen + 256 - 128;
        this.reccnt = this.bnklen / 128;
        return this.bnktop - this.bnklen & 0xFFFF;
    }

    @Override
    public int nextBnkRec(byte[] byArray, int n, int n2) {
        System.arraycopy(this.image, this.curdma, byArray, 5, 128);
        this.curdma -= 128;
        --this.reccnt;
        return this.reccnt;
    }

    @Override
    public int entryAddr() {
        return this.entry;
    }

    @Override
    public boolean needsOrg0() {
        return this.org0;
    }
}

