/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.print.attribute.DocAttribute;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.Timer;

class Diablo630
extends Printer_Paper
implements ActionListener,
Runnable {
    int _pages;
    int _partial;
    boolean gui = true;
    PrinterConsole _cons;
    private Timer timer;
    private File _file;
    private FileOutputStream _fos;
    private String _fosName;
    private boolean _append;
    private Font _font;
    private PaperDialog _pset;
    private FontDialog _fset;
    private InputStream _inp;
    SimpleDateFormat tagFmt = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
    private boolean _changed;
    private boolean _font_chg;
    private boolean _init;
    private boolean _page_done;
    private boolean _adjacent;
    private boolean _dir;
    private int _esc;
    private float _x;
    private float _y;
    private float _fw;
    private float _fa;
    private float _vsi;
    private float _hsi;
    private float _vsx;
    private float _hsx;
    PaperDialog.PaperMediaSize _ms;
    OrientationRequested _or;
    PaperPaintable _bkg;
    DocAttributeSet _dset;
    PrintRequestAttributeSet _rset;
    private float _lm;
    private float _tm;
    private int _lpi;
    private int _cpi;
    private float _pw;
    private float _ph;
    private float _ppw;
    private float _pph;
    private int _pwx;
    private int _phx;
    private Actions action = Actions.NONE;
    private String[] queueJob = null;
    private PipedInputStream _pipe_i;
    private PipedOutputStream _pipe_o;

    public DocAttributeSet getDocAttrs() {
        return this._dset;
    }

    public PrintRequestAttributeSet getPrtAttrs() {
        return this._rset;
    }

    public PaperPaintable getBkground() {
        return this._bkg;
    }

    private void clearPage() {
        this._adjacent = false;
        this.clear();
        this._y = 0.0f;
        this._x = 0.0f;
        this._page_done = false;
    }

    public void endJob() {
        if (this._cons != null) {
            this.timer.stop();
        }
        if (this._partial > 0) {
            this._partial = 0;
            ++this._pages;
        }
        if (this._cons != null) {
            this._cons.setPages(this._pages, this._partial);
            this._cons.setStatus("Done");
        }
        try {
            this._fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._fos = null;
        this.clearPage();
        if (this.action == Actions.NONE) {
            return;
        }
        if (this.action == Actions.DISCARD) {
            return;
        }
        if (this.action == Actions.SAVE) {
            if (this._file == null) {
                return;
            }
            this._append = false;
            String string = this._file.getParent();
            if (string == null) {
                string = ".";
            }
            String string2 = String.format("%s/job%s.ps", string, this.tagFmt.format(new Date()));
            File file = new File(string2);
            try {
                this._file.renameTo(file);
            }
            catch (Exception exception) {
                System.err.format("Failed to rename job to %s\n", string2);
            }
            return;
        }
        if (this.action == Actions.QUEUE && this._fosName != null) {
            String[] stringArray = new String[this.queueJob.length];
            for (int i = 0; i < this.queueJob.length; ++i) {
                stringArray[i] = this.queueJob[i].replaceAll("%f", this._fosName);
            }
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                int n = process.waitFor();
                if (n != 0) {
                    System.err.format("JobEnd exit %d: %s\n", n, stringArray[0]);
                }
            }
            catch (Exception exception) {
                System.err.format("JobEnd failed: %s - %s\n", stringArray[0], exception.getMessage());
            }
            this._append = false;
            return;
        }
    }

    private void setNewFile() {
        try {
            this._fos = new FileOutputStream(this._file, this._append);
            this._fosName = this._file.getAbsolutePath();
        }
        catch (Exception exception) {
            this._fosName = null;
            this._file = null;
            if (this._cons != null) {
                this._cons.setFileName(this._file);
            }
            try {
                this._fos = new FileOutputStream("/dev/null");
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this._append = true;
        if (this._changed) {
            this._changed = false;
            this.setupPaper(this._ms, this._or);
            this._partial = 0;
            this._pages = 0;
            if (this._cons != null) {
                this._cons.setPages(this._pages, this._partial);
                this._cons.setStatus("Idle");
            }
            this._init = false;
        }
    }

    public void reset() {
    }

    public void setupPaper(PaperDialog.PaperMediaSize paperMediaSize, OrientationRequested orientationRequested) {
        PaperDialog.PaperDim paperDim = this._pset.paperSize(paperMediaSize);
        if (paperDim == null) {
            System.err.println("Unsupported Page Size");
            System.exit(1);
        }
        this._ppw = paperDim.getWidth();
        this._pph = paperDim.getHeight();
        if (orientationRequested == OrientationRequested.LANDSCAPE) {
            this._pw = this._pph;
            this._ph = this._ppw;
        } else if (orientationRequested == OrientationRequested.PORTRAIT) {
            this._pw = this._ppw;
            this._ph = this._pph;
        } else {
            System.err.println("Unsupported Page Orientation");
            System.exit(1);
        }
        this._dset = new HashDocAttributeSet();
        this._dset.add(orientationRequested);
        this._dset.add(new DocPaperSize(this._ppw, this._pph, 25400));
        this._dset.add(new MediaPrintableArea(0.0f, 0.0f, this._ppw, this._pph, 25400));
        this._rset = new HashPrintRequestAttributeSet();
        this._rset.add(orientationRequested);
        this._rset.add(new ReqPaperSize(this._ppw, this._pph, 25400));
        this._rset.add(new MediaPrintableArea(0.0f, 0.0f, this._ppw, this._pph, 25400));
    }

    public void setPaper(float f, float f2) {
        float f3 = this._hsx * f;
        float f4 = this._vsx * f2;
        this._pwx = (int)Math.floor(this._hsx * this._pw);
        this._phx = (int)Math.floor(this._vsx * this._ph);
        this.setScale(this._pwx, this._phx);
        super.setPage(this._pwx, this._phx, (int)f3, (int)f4);
    }

    public void init(Graphics graphics) {
        if (this._init) {
            return;
        }
        this._init = true;
        if (this._cons != null) {
            this._cons.setChanges(false);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._font_chg) {
            String string = "%0" + this._cpi + "d";
            String string2 = String.format(string, 0);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            float f = (float)this._font.getStringBounds(string2, fontRenderContext).getWidth();
            LineMetrics lineMetrics = this._font.getLineMetrics(string2, fontRenderContext);
            this._fa = lineMetrics.getAscent();
            if (f != 72.0f) {
                float f2 = (72.0f - f) / (float)this._cpi / this._font.getSize2D();
                HashMap<TextAttribute, Float> hashMap = new HashMap<TextAttribute, Float>();
                hashMap.put(TextAttribute.TRACKING, Float.valueOf(f2));
                this._font = this._font.deriveFont(hashMap);
            }
            super.init(this._font, this._fa);
        }
        this._hsi = 72 / this._cpi;
        this._vsi = 72 / this._lpi;
        this._fw = this._hsi;
        this.setPaper(this._lm, this._tm);
    }

    private int getCpi(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
            if (n != 10 && n != 12 && n != 15) {
                n = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private int getLpi(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
            if (n != 6 && n != 8) {
                n = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public Diablo630(Properties properties, Vector<String> vector, InputStream inputStream) {
        String[] stringArray;
        int n;
        int n2 = 6;
        int n3 = 10;
        Font font = new Font("Monospaced", 0, 12);
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String string = properties.getProperty("diablo630_cpi");
        if (string != null && (n = this.getCpi(string)) != 0) {
            n3 = n;
        }
        if ((string = properties.getProperty("diablo630_lpi")) != null && (n = this.getLpi(string)) != 0) {
            n2 = n;
        }
        if ((string = properties.getProperty("diablo630_font")) == null || (stringArray2 = string.split("\\s")).length != 3) {
            // empty if block
        }
        if ((string = properties.getProperty("diablo630_paper")) != null) {
            stringArray3 = string.split("\\s");
        }
        if ((string = properties.getProperty("diablo630_nogui")) != null) {
            try {
                this.gui = Boolean.valueOf(string) == false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = properties.getProperty("diablo630_jobend")) != null && (stringArray = string.split("\\s")).length >= 1) {
            if (stringArray[0].equalsIgnoreCase("DISCARD")) {
                this.action = Actions.DISCARD;
            } else if (stringArray[0].equalsIgnoreCase("SAVE")) {
                this.action = Actions.SAVE;
            } else if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("QUEUE")) {
                this.action = Actions.QUEUE;
                this.queueJob = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            } else {
                System.err.format("Invalid jobend action: %s\n", string);
                this.action = Actions.NONE;
            }
        }
        for (String string2 : vector) {
            int n4;
            if (string2.startsWith("cpi=")) {
                n4 = this.getCpi(string2.substring(4));
                if (n4 == 0) continue;
                n3 = n4;
                continue;
            }
            if (string2.startsWith("lpi=")) {
                n4 = this.getLpi(string2.substring(4));
                if (n4 == 0) continue;
                n2 = n4;
                continue;
            }
            if (string2.startsWith("font=")) {
                stringArray2 = string2.substring(5).split(",");
                if (stringArray2.length == 3) continue;
                continue;
            }
            if (string2.startsWith("paper=")) {
                stringArray3 = string2.substring(6).split(",");
                continue;
            }
            if (!string2.equals("nogui")) continue;
            this.gui = false;
        }
        if (stringArray2 != null) {
            int n5 = 0;
            int n6 = 12;
            try {
                n6 = Integer.valueOf(stringArray2[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            font = new Font(stringArray2[0], n5, n6);
        }
        this._ms = PaperDialog.PaperMediaSize.NA_LETTER;
        this._or = OrientationRequested.PORTRAIT;
        this._bkg = null;
        if (stringArray3 != null) {
            for (String string3 : stringArray3) {
                if (string3.equalsIgnoreCase("LETTER")) {
                    this._ms = PaperDialog.PaperMediaSize.NA_LETTER;
                    continue;
                }
                if (string3.equalsIgnoreCase("LEGAL")) {
                    this._ms = PaperDialog.PaperMediaSize.NA_LEGAL;
                    continue;
                }
                if (string3.equalsIgnoreCase("FORMS")) {
                    this._ms = PaperDialog.PaperMediaSize.NA_FORMS;
                    continue;
                }
                if (string3.equalsIgnoreCase("PORTRAIT")) {
                    this._or = OrientationRequested.PORTRAIT;
                    continue;
                }
                if (string3.equalsIgnoreCase("LANDSCAPE")) {
                    this._or = OrientationRequested.LANDSCAPE;
                    continue;
                }
                if (!string3.equalsIgnoreCase("GREENBAR")) continue;
                this._bkg = new GreenbarPaper();
            }
        }
        this._inp = inputStream;
        this._font = font;
        this._lpi = n2;
        this._cpi = n3;
        this._lm = 0.0f;
        this._tm = 0.0f;
        this._dir = true;
        this._vsi = 72 / this._lpi;
        this._hsi = 72 / this._cpi;
        this._vsx = 72.0f;
        this._hsx = 72.0f;
        this._adjacent = true;
        this._page_done = false;
        this._esc = 0;
        this._pages = 0;
        this._partial = 0;
        this._changed = true;
        this._font_chg = true;
        this._init = false;
        this._append = false;
        this._cons = null;
        this._pset = new PaperDialog();
        this.setupPaper(this._ms, this._or);
        if (this.gui) {
            this._fset = new FontDialog();
            this._cons = new PrinterConsole("Diablo 630 Console");
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("New Output File", 70);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Discard", 68);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            this._cons.addMenu(jMenu);
            jMenu = new JMenu("Settings");
            jMenuItem = new JMenuItem("Paper", 80);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Font", 87);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            this._cons.addMenu(jMenu);
            jMenu = new JMenu("Controls");
            jMenuItem = new JMenuItem("Form Feed", 69);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("End Job", 74);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            this._cons.addMenu(jMenu);
            this.timer = new Timer(50, this);
            this._cons.setFont(this._font);
            this._cons.setPitch(this._cpi, this._lpi);
            this._cons.setPaper(this._ms, this._or);
            this._cons.setPosition(this._lm, this._tm);
            this._cons.setPages(this._pages, this._partial);
            this._cons.setStatus("Idle");
        }
        this._pipe_i = new PipedInputStream();
        try {
            this._pipe_o = new PipedOutputStream(this._pipe_i);
        }
        catch (Exception exception) {
            System.err.println("Unable to create pipe!");
            System.exit(1);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void endPage() {
        this._page_done = true;
        ++this._pages;
        this._partial = 0;
        if (this._cons != null) {
            this._cons.setPages(this._pages, this._partial);
        }
        this._y = 0.0f;
    }

    private void index() {
        this._y += this._vsi;
        if (this._y >= (float)this._phx) {
            this.endPage();
        }
    }

    private void revindex() {
        this._y -= this._vsi;
        if (this._y < 0.0f) {
            this._y = 0.0f;
        }
    }

    private void space() {
        this._x += this._hsi;
        if (this._x >= (float)this._pwx) {
            this._x = this._pwx - 1;
        }
    }

    private void bkspace() {
        this._x -= this._hsi;
        if (this._x < 0.0f) {
            this._x = 0.0f;
        }
    }

    private void forward() {
        if (this._dir) {
            this.space();
        } else {
            this.bkspace();
        }
    }

    private void backward() {
        if (this._dir) {
            this.bkspace();
        } else {
            this.space();
        }
    }

    private void tab() {
        int n = (int)Math.floor(this._x / this._fw);
        n &= 0xFFFFFFF8;
        this._x = (float)(n += 8) * this._fw;
    }

    private String do_esc2(byte by) {
        String string = null;
        switch (this._esc) {
            case 30: {
                this._vsi = (float)(by - 1) * this._vsx / 48.0f;
                break;
            }
            case 31: {
                this._hsi = (float)(by - 1) * this._hsx / 120.0f;
            }
        }
        this._esc = 0;
        return string;
    }

    private String do_esc(byte by) {
        if (this._esc > 1) {
            return this.do_esc2(by);
        }
        String string = null;
        this._esc = 0;
        switch (by) {
            case 30: 
            case 31: {
                this._esc = by;
                break;
            }
            case 53: {
                this._dir = true;
                break;
            }
            case 54: {
                this._dir = false;
                break;
            }
            case 10: {
                this.revindex();
                this._adjacent = false;
                break;
            }
            case 72: {
                string = "\u00a7";
                break;
            }
            case 73: {
                string = "\u00a3";
                break;
            }
            case 74: {
                string = "\u00a8";
                break;
            }
            case 75: {
                string = "\u00e7";
                break;
            }
            case 89: {
                string = "\u00a2";
                break;
            }
            case 90: {
                string = "\u00ac";
            }
        }
        return string;
    }

    public boolean do_char(byte by) {
        if (this._cons != null) {
            if (!this.timer.isRunning()) {
                this._cons.setStatus("Active");
            }
            this.timer.restart();
        }
        if (this._page_done) {
            this.clearPage();
        }
        String string = null;
        if (this._esc > 0) {
            string = this.do_esc(by);
        } else if (by < 32) {
            string = null;
            switch (by) {
                case 13: {
                    this._adjacent = false;
                    this._dir = true;
                    this._x = 0.0f;
                    break;
                }
                case 10: {
                    this._adjacent = false;
                    this.index();
                    break;
                }
                case 8: {
                    this._adjacent = false;
                    this.backward();
                    break;
                }
                case 32: {
                    this._adjacent = false;
                    this.forward();
                    break;
                }
                case 9: {
                    this._adjacent = false;
                    this.tab();
                    break;
                }
                case 12: {
                    this._adjacent = false;
                    this.endPage();
                    break;
                }
                case 27: {
                    this._esc = 1;
                    break;
                }
                case 7: {
                    break;
                }
            }
        } else {
            string = new String();
            string = string + (char)by;
        }
        int n = (int)Math.ceil(this._y / (float)this._phx * 10.0f);
        if (n > 9) {
            n = 9;
        }
        if (n > this._partial) {
            this._partial = n;
            if (this._cons != null) {
                this._cons.setPages(this._pages, this._partial);
            }
        }
        if (string != null) {
            if (this._adjacent) {
                if (this._dir) {
                    super.appendLastPlot(string, this._x, this._y);
                } else {
                    super.prependLastPlot(string, this._x, this._y);
                }
            } else {
                super.addPlot(string, this._x, this._y);
            }
            this.forward();
            this._adjacent = Math.round(this._hsi) == Math.round(this._fw);
        }
        return this._page_done;
    }

    public boolean getFile() {
        boolean bl = false;
        SuffFileChooser suffFileChooser = new SuffFileChooser("Select", this._file);
        int n = suffFileChooser.showDialog(this._cons.getFrame());
        if (n == 0) {
            this._file = suffFileChooser.getSelectedFile();
            bl = true;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this._cons == null) {
            return;
        }
        if (actionEvent.getSource() == this.timer) {
            this.timer.stop();
            this._cons.setStatus("Idle");
            return;
        }
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getMnemonic() == 70) {
                boolean bl = this.getFile();
                if (bl) {
                    this._append = false;
                    this._changed = true;
                    this._cons.setChanges(true);
                    this._cons.setFileName(this._file);
                    this.inject(255);
                }
                return;
            }
            if (jMenuItem.getMnemonic() == 68) {
                this._append = false;
                this._changed = true;
                this._cons.setChanges(true);
                this.inject(255);
                return;
            }
            if (jMenuItem.getMnemonic() == 80) {
                this._pset.setMedia(this._ms);
                this._pset.setOrient(this._or);
                this._pset.setLeft(this._lm);
                this._pset.setTop(this._tm);
                boolean bl = this._pset.doDialog(this._cons.getFrame());
                if (bl) {
                    this._ms = this._pset.getMedia();
                    this._or = this._pset.getOrient();
                    this._bkg = this._pset.getBkground();
                    this._lm = this._pset.getLeft();
                    this._tm = this._pset.getTop();
                    this._changed = true;
                    this._cons.setChanges(true);
                    this._cons.setPaper(this._ms, this._or);
                    this._cons.setPosition(this._lm, this._tm);
                    this.inject(255);
                }
                return;
            }
            if (jMenuItem.getMnemonic() == 87) {
                this._fset.setFont(this._font);
                this._fset.setPitch(this._cpi, this._lpi);
                boolean bl = this._fset.doDialog(this._cons.getFrame());
                if (bl) {
                    this._font = this._fset.getFont();
                    this._cpi = this._fset.getCPI();
                    this._lpi = this._fset.getLPI();
                    this._changed = true;
                    this._font_chg = true;
                    this._cons.setChanges(true);
                    this._cons.setFont(this._font);
                    this._cons.setPitch(this._cpi, this._lpi);
                    this.inject(255);
                }
                return;
            }
            if (jMenuItem.getMnemonic() == 69) {
                this.inject(12);
                return;
            }
            if (jMenuItem.getMnemonic() == 74) {
                this.inject(255);
                return;
            }
        }
        System.err.println("Unknown action event");
    }

    private void inject(int n) {
        try {
            this._pipe_o.write((byte)n);
            this._pipe_o.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        int n = -1;
        do {
            try {
                n = this._inp.read();
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n < 0 || n > 255) continue;
            try {
                this._pipe_o.write((byte)n);
                this._pipe_o.flush();
            }
            catch (Exception exception) {
                n = -1;
            }
        } while (n >= 0);
        try {
            this._pipe_o.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int readPrinterStream() {
        int n = -1;
        try {
            n = this._pipe_i.read();
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public void runPrinter(String string) {
        Print2DtoStream print2DtoStream;
        int n = 0;
        this._file = new File(string);
        if (this._cons != null) {
            this._cons.setFileName(this._file);
        }
        do {
            this.setNewFile();
            print2DtoStream = new Print2DtoStream(this._fos, this);
            this.endJob();
        } while ((n = print2DtoStream.getStatus()) >= 0);
    }

    class ReqPaperSize
    extends MediaSize
    implements PrintRequestAttribute {
        public ReqPaperSize(float f, float f2, int n) {
            super(f, f2, n);
        }
    }

    class DocPaperSize
    extends MediaSize
    implements DocAttribute {
        public DocPaperSize(float f, float f2, int n) {
            super(f, f2, n);
        }
    }

    private static enum Actions {
        NONE,
        DISCARD,
        SAVE,
        QUEUE;

    }
}

